/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.constants.GuiComponentType;
import noppes.npcs.api.gui.IScroll;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;

public class CustomGuiScrollWrapper
extends CustomGuiComponentWrapper
implements IScroll {
    int defaultSelection = -1;
    int height;
    String[] list;
    boolean multiSelect = false;
    int width;

    public CustomGuiScrollWrapper() {
    }

    public CustomGuiScrollWrapper(int id, int x, int y, int width, int height, String[] list) {
        this.setId(id);
        this.setPos(x, y);
        this.setSize(width, height);
        this.setList(list);
    }

    @Override
    public CustomGuiComponentWrapper fromNBT(NBTTagCompound nbt) {
        super.fromNBT(nbt);
        this.setSize(nbt.func_74759_k("size")[0], nbt.func_74759_k("size")[1]);
        if (nbt.func_74764_b("default")) {
            this.setDefaultSelection(nbt.func_74762_e("default"));
        }
        NBTTagList tagList = nbt.func_150295_c("list", 8);
        String[] list = new String[tagList.func_74745_c()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            list[i] = ((NBTTagString)tagList.func_179238_g(i)).func_150285_a_();
        }
        this.setList(list);
        this.setMultiSelect(nbt.func_74767_n("multiSelect"));
        return this;
    }

    @Override
    public int getDefaultSelection() {
        return this.defaultSelection;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String[] getList() {
        return this.list;
    }

    @Override
    public int getType() {
        return GuiComponentType.SCROLL.get();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    @Override
    public IScroll setDefaultSelection(int defaultSelection) {
        this.defaultSelection = defaultSelection;
        return this;
    }

    @Override
    public IScroll setList(String[] list) {
        this.list = list;
        return this;
    }

    @Override
    public IScroll setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
        return this;
    }

    @Override
    public IScroll setSize(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new CustomNPCsException("Invalid component width or height: [" + width + ", " + height + "]", new Object[0]);
        }
        this.width = width;
        this.height = height;
        return this;
    }

    @Override
    public NBTTagCompound toNBT(NBTTagCompound nbt) {
        super.toNBT(nbt);
        nbt.func_74783_a("size", new int[]{this.width, this.height});
        if (this.defaultSelection >= 0) {
            nbt.func_74768_a("default", this.defaultSelection);
        }
        NBTTagList list = new NBTTagList();
        for (String s : this.list) {
            list.func_74742_a((NBTBase)new NBTTagString(s));
        }
        nbt.func_74782_a("list", (NBTBase)list);
        nbt.func_74757_a("multiSelect", this.multiSelect);
        return nbt;
    }
}

